package org.msh.tb.bd.tbforms.query;

import org.msh.tb.bd.Quarter;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import javax.persistence.Query;

/**
 * Created by Mauricio Santos on 18/04/2017.
 */
public class TBFormQueryUtils {

    /**
     * Creates Query instance for query string passed as param, setting the conditions.
     * Used in Tb Form 11 block 1 and in Tb Form 12
     * @param queryStr
     * @param tbunit
     * @param adminUnit
     * @param workspace
     * @param selectedQuarter
     * @param em
     * @return
     */
    public static Query createQuery(String queryStr, Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        Query query;

        if (tbunit != null) {
            // add tbunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            query = em.createQuery(queryStr);
            query.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            query = em.createQuery(queryStr);
            query.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            queryStr = queryStr.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            query = em.createQuery(queryStr);
            query.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TBForm11Block1Query: Tbunit, adminunit or workspace must be set.");
        }

        query.setParameter("iniDate", selectedQuarter.getIniDate());
        query.setParameter("endDate", selectedQuarter.getEndDate());

        return query;
    }

}
